// simple, generic collection - queue not appropriate since we are not removing things
// This module intentionally does not do any dynamic memory allocation
// Caller must allocate all required memory

#include "collection.h"

// todo: add semaphore here?

void CollectionCreate(COLLECTION * pc, UINT32 maxItems, UINT32 itemBytes, UINT8 * pData)
{
    pc->maxItems = maxItems;
    pc->itemCnt = 0;
    pc->itemBytes = itemBytes;
    pc->pData = pData;
}

void * CollectionGetFirst(COLLECTION * pc, UINT32 * pIdx)
{
    if(pc->itemCnt == 0)
    {
        return 0;
    }
    *pIdx = 0;
    return pc->pData;
}

void * CollectionGetNext(COLLECTION * pc, UINT32 * pIdx)
{
    *pIdx = *pIdx + 1;
    if(*pIdx >= pc->itemCnt)
    {
        return 0;
    }
    return pc->pData + (*pIdx*pc->itemBytes);
}

void * CollectionGetAt(COLLECTION * pc, UINT32 i)
{
    if(i >= pc->itemCnt)
    {
        return 0;
    }
    return pc->pData + i*pc->itemBytes;
}

void * CollectionMakeNewItem(COLLECTION * pc, UINT32 * pIdx)
{
    UINT8 * pData;

    if(pc->itemCnt >= pc->maxItems)
    {
        return 0;
    }
    *pIdx = pc->itemCnt;
    pData = pc->pData + *pIdx * pc->itemBytes;
    pc->itemCnt++;
    return pData;
}
